% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_depth.R
\name{tree_depth}
\alias{tree_depth}
\title{Tree depth}
\usage{
tree_depth(tree, abund)
}
\arguments{
\item{tree}{A phylogenetic tree of class 'phylo'. The tip labels must match the row names in the OTU table. Use the function match_data() if the OTU names do not match.}

\item{abund}{A vector or a matrix/data.frame indicating the relative abundances of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}
}
\value{
A tree depth value
}
\description{
Computes phylogenetic tree depth based from a phylogenetic tree and a vector of (relative) abundances.
}
\details{
Tree depth
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
tree_depth(tree=bat.diet.tree,abund=bat.diet.otutable)
tree_depth(bat.diet.tree,bat.diet.otutable)
}
\seealso{
\code{\link{div_part}}, \code{\link{gamma_div}}, \code{\link{match_data}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{phylogeny}
\keyword{tree}
