% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_intens_spde.R
\name{est_intens_spde}
\alias{est_intens_spde}
\title{Estimates the intensity of the point pattern by using the SPDE method from r-INLA.}
\usage{
est_intens_spde(coords, win = NULL, npixel = 50, fine_mesh = FALSE,
  mesh = NULL, weights = NULL, alpha = 2, ...)
}
\arguments{
\item{coords}{ppp object or matrix with x and y coordinates of the observed bombs}

\item{win}{observation window, either of class owin or a matrix with the x and y coordinates of the boundary,
not neccessary if coords is a ppp object}

\item{npixel}{number of pixel per dimension (see \code{\link[spatstat]{spatstat.options}})}

\item{fine_mesh}{logical, if FALSE a coarse mesh will be created, if TRUE a fine mesh will be created, 
only used if argument mesh is NULL}

\item{mesh}{(optional) a predefined mesh for the spde model}

\item{weights}{(optional) integration weights for the spde model, only used if argument mesh is NULL}

\item{alpha}{(optional) alpha value for the spde model, only used if argument spde is NULL}

\item{...}{additional arguments for the construction of the spde model (see \code{\link[INLA]{inla.spde2.matern}})}
}
\value{
A list of
   \item{ intensest }{ Pixel image with the estimated intensities of the random field. }
   \item{ mesh }{ The mesh. }
}
\description{
Estimates the intensity of the point pattern by using the SPDE method from r-INLA.
}
\examples{
\dontrun{
data(craterA)
est_spde <- est_intens_spde(coords=craterA)
image.plot(list(x=est_spde$intensest$xcol, y=est_spde$intensest$yrow, 
                z=log(t(est_spde$intensest$v))), main="estimated logarithmic intensity")
points(craterA)
}
}
