% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{tradesCondition}
\alias{tradesCondition}
\title{Delete entries with abnormal trades condition.}
\usage{
tradesCondition(
  tData,
  validConds = c("", "@", "E", "@E", "F", "FI", "@F", "@FI", "I", "@I")
)
}
\arguments{
\item{tData}{an \code{xts} or \code{data.table} object containing the time series data, with 
one column named \code{"COND"} indicating the Sale Condition.}

\item{validConds}{a character vector containing valid sales conditions defaults to \cr
\code{c('', '@', 'E', '@E', 'F', 'FI', '@F', '@FI', 'I', '@I')}. See details.}
}
\value{
\code{xts} or \code{data.table} object depending on input.
}
\description{
Delete entries with abnormal trades condition
}
\details{
To get more information on the sales conditions, see the NYSE documentation. Section about Daily TAQ Trades File.
The current version (as of May 2020) can be found online at \href{https://www.nyse.com/publicdocs/nyse/data/Daily_TAQ_Client_Spec_v3.3.pdf}{NYSE's webpage}
}
\note{
Some CSV readers and the WRDS API parses empty strings as NAs. We transform \code{NA} values in COND to \code{""}.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
