% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highmaps.R
\name{download_map_data}
\alias{download_map_data}
\title{Helper function to download the map data form a url}
\usage{
download_map_data(url = "custom/world.js", showinfo = FALSE, quiet = FALSE)
}
\arguments{
\item{url}{The map's url.}

\item{showinfo}{Show the properties of the downloaded map to know how
are the keys to add data in \code{hcmap}.}

\item{quiet}{Boolean parameter to turn off download messages (on by default).}
}
\description{
The urls are listed in \url{https://code.highcharts.com/mapdata/}.
}
\examples{
\dontrun{
mpdta <- download_map_data("https://code.highcharts.com/mapdata/countries/us/us-ca-all.js")
mpdta <- download_map_data("https://code.highcharts.com/mapdata/countries/us/us-ca-all.js",
  quiet = TRUE
)
str(mpdta, 1)
}
}
\seealso{
\code{\link{hcmap}}
}
