% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuals.R
\name{outlying_elements}
\alias{outlying_elements}
\title{Extract the outlying elements from each set pair}
\usage{
outlying_elements(x, counts = TRUE)
}
\arguments{
\item{x}{A HierarchicalSet object}

\item{counts}{Should number of elements rather than the actual elements be
returned. Defaults to \code{TRUE}}
}
\value{
A data.frame containing information on the outlying elements of each
set pair. Only pairs with outlying elements are returned. The 'setX' coloumn
contains the index of the first set in the pair and the 'setY' column
contains the index of the second set in the pair. If \code{counts = TRUE}
then the 'nOutliers' column contains the number of outlying elements for each
pair. If \code{counts = FALSE} the the 'outlier' column contains the index of
the outlying elements for each pair
}
\description{
This function detects the outlying elements of each pair of sets in a
HierarchicalSet object. An outlying element is defined as an element in the
intersection of the two sets, but not in the intersection of their nearest
common set family in the hierarchy.
}
\examples{
data('twitter')

twitSet <- create_hierarchy(twitter)

# Just get the counts
countOut <- outlying_elements(twitSet)
head(countOut)

# Or the actual elements
elemOut <- outlying_elements(twitSet, FALSE)
head(elemOut)

}
\seealso{
\code{\link{plot_outlier_distribution}} for plotting the
distribution  of outlying elements in a HierarchicalSet object
}

