% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgwr.R
\name{summary.hgwrm}
\alias{summary.hgwrm}
\title{Summary an \code{hgwrm} object.}
\usage{
\method{summary}{hgwrm}(object, ..., test_hetero = FALSE)
}
\arguments{
\item{object}{An \code{hgwrm} object returned from \code{\link[=hgwr]{hgwr()}}.}

\item{\dots}{Other arguments passed from other functions.}

\item{test_hetero}{Logical/list value.
Whether to test the spatial heterogeneity of local fixed effects.
If it is set to \code{FALSE}, the test will not be executed.
If it is set to \code{TRUE}, the test will be executed with default parameters (see details below).
It accepts a list to enable the test with specified parameters.}
}
\value{
A list containing summary informations of this \code{hgwrm} object
with the following fields.
\describe{
\item{\code{diagnostic}}{A list of diagnostic information.}
\item{\code{random.stddev}}{The standard deviation of random effects.}
\item{\code{random.corr}}{The correlation matrix of random effects.}
\item{\code{residuals}}{The residual vector.}
}
}
\description{
Summary an \code{hgwrm} object.
}
\details{
The parameters used to perform test of spatial heterogeneity are
\describe{
\item{\code{bw}}{Bandwidth (unit: number of nearest neighbours) used to make spatial kernel density estimation. Default: \code{10}.}
\item{\code{poly}}{The number of polynomial terms used in the local polynomial estimation. Default: \code{2}.}
\item{\code{resample}}{Total resampling times. Default: \code{5000}.}
}
}
\seealso{
\code{\link[=hgwr]{hgwr()}}.
}
