% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\name{percentCorrectListNonSymmetric}
\alias{percentCorrectListNonSymmetric}
\title{percentCorrectList for non-symmetric heuristics}
\usage{
percentCorrectListNonSymmetric(test_data, fitted_heuristic_list)
}
\arguments{
\item{test_data}{Data to try to predict.  Must have same criterion column
and cols_to_fit as the data heuristics were fit to.}

\item{fitted_heuristic_list}{A list of one or more heuristics fitted to
data, e.g. the output of ttbModel.}
}
\value{
A one-row data.frame of numbers from 0 to 100, the percent correc
  of each heuristic.  Each column is named with the heuristic's class or
  the fit name.
}
\description{
Same as percentCorrectList but for weird heuristics that do not
consistently choose the same row.  When a symmetric heuristic predicts
row1 > row2, then it also predicts row2 < row1.  Those can be used
with percentCorrectList.  All heuristics built into heuristica
qualify.  They will get the same answers for percentCorrectList
and percentCorrectListNonSymmetric.  But a non-symmetric heuristic
will only get correct answers for percentCorrectListNonSymmetric.
}
\seealso{
\code{\link{percentCorrectList}} which is faster but wil only be accurate
  for symmetric heuristics.  (percentCorrectListNonSymmetric will be
  accurate for both symmetric and non-symmetric heuristics, but it's slower.)
}

