% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_pair_apply.R
\name{heuristicsList}
\alias{heuristicsList}
\title{Wrapper for fitted heuristics to generate predictions with rowPairApply.}
\usage{
heuristicsList(list_of_fitted_heuristics, fn)
}
\arguments{
\item{list_of_fitted_heuristics}{Normally a list of predictProbInternal
implementers, e.g. a fitted ttb model.}

\item{fn}{The function to be called on the heuristics, which is typically
predictPairInternal (or the experimental function predictProbInternal)
but can be any function with the signature function(object, row1, row2)
that is implemented by the heuristics in list_of_fitted_heuristics.}
}
\value{
An object of class heuristics, which implements createFunction.
  Users will generally not use this directly-- rowPairApply will.
}
\description{
One or more fitted heuristics can be passed in.  They must all implement
predictProbInternal.  Users will generally not use the output directly.
}
\examples{
## This is typical usage:
data <- cbind(y=c(30,20,10,5), x1=c(1,1,0,0), x2=c(1,1,0,1))
ttb <- ttbModel(data, 1, c(2:ncol(data)))
rowPairApply(data, heuristicsList(list(ttb), predictPairInternal))
## This outputs ttb's predictions for all 6 row pairs of data.
## (It has 6 row pairs because 4*2/2 = 6.)  It gets the predictions
## by calling ttb's predictPairInternal.

}
\seealso{
\code{\link{heuristics}} and  \code{\link{heuristicsProb}} for 
  simpler versions of this function.
}

