% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_ctrl.R
\name{pin_ctrl}
\alias{pin_ctrl}
\alias{hetu_ctrl}
\title{Finnish Personal Identification Number Validator}
\usage{
pin_ctrl(pin, allow.temp = FALSE)

hetu_ctrl(pin, allow.temp = FALSE)
}
\arguments{
\item{pin}{Finnish personal identification number as a character vector, or
vector of identification numbers as a character vectors.}

\item{allow.temp}{If TRUE, temporary PINs (personal numbers 900-999) are handled
similarly to regular PINs (personal numbers 002-899), meaning that otherwise valid
temporary PIN will return a TRUE. Default is \code{FALSE}.}
}
\value{
Logical indicating whether the input string is a valid Finnish personal identification number,
}
\description{
Validate Finnish personal identification numbers (hetu).
}
\examples{
pin_ctrl("010101-0101") # TRUE
pin_ctrl("010101-010A") # FALSE
hetu_ctrl("010101-0101") # TRUE
hetu_ctrl("010101-010A") # FALSE
}
\seealso{
\code{\link{hetu}} For extracting information from Finnish personal
  identification numbers.
}
\author{
Pyry Kantanen
}
