% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_plot.R
\name{plot.RI.R2.result}
\alias{plot.RI.R2.result}
\title{Make a plot of the treatment effect R2 estimates}
\usage{
\method{plot}{RI.R2.result}(
  x,
  main = paste("R2 for Het Tx (", x$type, ")", sep = ""),
  ADD = FALSE,
  ...
)
}
\arguments{
\item{x}{Results from est.beta, etc.}

\item{main}{Title for plot}

\item{ADD}{TRUE if add to existing plot. FALSE make a new plot.}

\item{...}{Arguments to pass to plotting of points.}
}
\description{
Make a plot of the treatment effect R2 estimates
}
\examples{
df <- make.randomized.dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
es <- estimate_systematic( Yobs ~ Z,  interaction.formula = ~ A + B, data = df )
r2_out <- R2(es)
plot(r2_out)

}
\seealso{
calc.beta
}
