% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_joined_surv}
\alias{params_joined_surv}
\title{Parameters of joined survival models}
\usage{
params_joined_surv(..., times)
}
\arguments{
\item{...}{Objects of class \code{\link{params_surv}}, which can be named.}

\item{times}{A numeric vector of times at which to join models.}
}
\value{
An object of class \code{params_joined_surv}, which is a list containing two elements:
\describe{
\item{models}{A list of \code{\link{params_surv}} objects from each statistical model
to be joined.}
\item{times}{Equivalent to the argument \code{times}.}
}
}
\description{
Create a list containing the parameters of survival models joined at specified time points. See
\code{\link{joined}} for more details.
}
\examples{
library("flexsurv")
fit_exp <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "exp")
fit_wei <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "weibull")
params_surv_exp <- create_params(fit_exp, n = 2)
params_surv_wei <- create_params(fit_wei, n = 2)
params_joined_surv <- params_joined_surv(exp = params_surv_exp,
                                         wei = params_surv_wei,
                                         times = 3)
print(params_joined_surv)
}
