% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_mats.R
\name{input_mats}
\alias{input_mats}
\title{Input matrices for a statistical model}
\usage{
input_mats(X, ...)
}
\arguments{
\item{X}{A list of input matrices for predicting the values of each parameter
in a statistical model. May also be a list of lists of input matrices when a
list of separate models is fit (e.g., with \code{\link[=flexsurvreg_list]{flexsurvreg_list()}}).}

\item{...}{Arguments to pass to \code{\link[=id_attributes]{id_attributes()}}.}
}
\description{
Create an object of class \code{input_mats}, which contains inputs matrices
for simulating a statistical model. Consists of (i) input matrices, \code{X}, and
(ii) \link[=id_attributes]{metadata} used to index each matrix in \code{X}.
More details are provided under "Details" below.
}
\details{
Each row of each matrix \code{X} is an input vector, \eqn{x_{hik}}, where \eqn{h} denotes
a health-related index, \eqn{i} indexes a patient, and \eqn{k} is a treatment strategy.
A health-related index is either a health state
(e.g., \code{state_id} or a transition between health states (e.g., \code{transition_id}).
In some cases, the health-related index \eqn{h} can be suppressed and separate models
can be fit for each health index. This is, for instance, the case in a \link[=Psm]{partitioned survival model} where separate models are fit for each survival endpoint.

The rows of the matrices in \code{X} must be sorted in a manner consistent with the ID variables as
described in \code{\link[=id_attributes]{id_attributes()}}.
}
\examples{
strategies <- data.frame(strategy_id = c(1, 2))
patients <- data.frame(patient_id = seq(1, 3), 
                          age = c(45, 47, 60),
                          female = c(1, 0, 0),
                          group = factor(c("Good", "Medium", "Poor")))
hesim_dat <- hesim_data(strategies = strategies,
                        patients = patients)

dat <- expand(hesim_dat, by = c("strategies", "patients"))
input_mats <- input_mats(X = list(mu = model.matrix(~ age, dat)),
                         strategy_id = dat$strategy_id,
                         n_strategies = length(unique(dat$strategy_id)),
                         patient_id = dat$patient_id,
                        n_patients = length(unique(dat$patient_id)))
print(input_mats)
}
\seealso{
\code{\link[=create_input_mats]{create_input_mats()}}
}
