% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border.grid.R
\name{border.grid}
\alias{border.grid}
\alias{border_grid}
\alias{borderGrid}
\alias{BorderGrid}
\title{Construct border for grid}
\usage{
border.grid(x, y, proj4string)

border_grid(x, y, proj4string)

borderGrid(x, y, proj4string)

BorderGrid(x, y, proj4string)
}
\arguments{
\item{x}{A vector or matrix of x coordinates.  See
Details.}

\item{y}{A vector or matrix of y coordinates.  See
Details.}

\item{proj4string}{A projection string of class
\code{\link[sp]{CRS-class}}.  If not provided, then
default values are used.  This should be changed with
caution.}
}
\value{
A \code{\link[sp]{SpatialPolygons}} object.
}
\description{
\code{border.grid} determines the border for
data on a grid.  \code{x} and \code{y} must define a
regular or irregular grid.  See Details.
}
\details{
A regular grid is defined by ascending numeric vectors
\code{x} and \code{y}.  A vector \code{x} is ascending if
\code{x[i] < x[j]} for \code{i < j}.

An irregular grid is defind by ascending matrices.
A matrix \code{x} is ascending if \code{x[i, j] < x[i, l]}
for \code{j < l} and if \code{x[i, j] < x[k, j]}
and \code{j < k}.
}
\examples{
# create x and y defining square border
x = seq(min(lon), max(lon), length = 60)
y = seq(min(lat), max(lat), length = 80)
border = border.grid(x, y)
sp::plot(border)

# use lon and lat to define border of an irregular grid
border2 = border.grid(lon, lat)
sp::plot(border2)
}
\author{
Joshua French
}
