% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rh.R
\name{rh}
\alias{rh}
\title{Rotated H-transform}
\usage{
rh(x, a, transpose = FALSE)
}
\arguments{
\item{x}{A matrix-like object.  See Details.}

\item{a}{An d-dimensional array}

\item{transpose}{A logical value.  The Default is
\code{FALSE}.  If \code{TRUE}, then the transpose of
\code{A}}
}
\value{
A rotated, h-transformed array
}
\description{
A rotation of the H-transform of the array \code{a} by a
matrix \code{x}.
}
\details{
\code{x} should be matrix-like.  This function has been
tested when \code{x} is a \code{matrix} object or a
\code{\link[Matrix]{Matrix}}.

Assuming \code{a} is of size \eqn{c_1 \times c_2 \times
\dots \times c_d}, then \code{x} is of size \eqn{r \times
c_1}.
}
\examples{
dim = c(10:12)
# construct random array
a = array(rnorm(prod(dim)), dim = dim)
# construct random matrix
x = matrix(rnorm(15 * dim[1]), nrow = 15)
rhxa = rh(x, a)
}
\references{
Currie, I. D., Durban, M. and Eilers, P. H.
(2006), Generalized linear array models with applications
to multidimensional smoothing. Journal of the Royal
Statistical Society: Series B (Statistical Methodology),
68: 259-280. <doi:10.1111/j.1467-9868.2006.00543.x>

Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
