
\name{hergm.gof}

\alias{hergm.gof}

\alias{gof}

\title{Goodness-of-fit}

\description{

The function \code{hergm.gof} assesses the goodness-of-fit of the model by generating posterior predictions based on a MCMC sample generated by function \code{hergm} and postprocessed by function \code{hergm.postprocess}.

}

\usage{

hergm.gof(sample = NULL,
          verbose = 1,
          \dots)

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm} and postprocessed by function \code{hergm.postprocess}.}

\item{verbose}{if \code{verbose == -1}, no console output; if \code{verbose == 0}, short console output; if \code{verbose == +1}, long console output.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\item{component.number}{number of components.}

\item{max.component.size}{size of largest component.}

\item{distance}{geodesic distance of pairs of nodes.}

\item{degree}{degree of nodes.}

\item{edges}{number of edges.}

\item{stars}{number of \code{2}-stars.}

\item{triangle}{number of triangles.}

}

\seealso{network, hergm, hergm.postprocess}

\examples{
\dontrun{
data(example)

sample <- hergm(d ~ edges_ij + triangle_ijk)

processed.sample <- hergm.postprocess(sample)

hergm.gof(processed.sample)
}
}

