% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hei.R
\name{hei}
\alias{hei}
\title{Individual HEI scores calculation.}
\usage{
hei(fped, diet, demograph, agethresh = 2, verbose = FALSE)
}
\arguments{
\item{fped}{Food Pattern Equivalent Database data; see \link{get_fped}}

\item{diet}{dietary data from NHANES database; see \link{get_diet}}

\item{demograph}{demographic data from NHANES database; see \link{get_demo}}

\item{agethresh}{numeric threshold for age in years of survey participants to be included; any individual less than the value specified will be excluded; defaults to 2}

\item{verbose}{boolean indicating whether or not all columns from processed data should be output; default is \code{FALSE} designating only the following are included in the returned \code{data.frame}:
\itemize{
\item SEQN: Respondent sequence number
\item RIDAGEYR: Best age in years of the sample person at time of HH screening. Individuals 85 and over are topcoded at 85 years of age
\item HEI: Overall Health Eating Index score for the given participant
}}
}
\value{
Object of class \code{data.frame}; defaults to only include columns for respondent identifier, age, and overall HEI score of each individual; this can be overidden with the \code{verbose} parameter to output all columns of the input data sets as well as 33 columns of calculated data related to HEI scoring and, significantly, a 70th column containing the total HEI score for each participant.
}
\description{
\code{hei} calculates a Health Eating Index (HEI) score for individuals in the National Health and Nutrition Examination Survey (NHANES) studies based on input dietary, demographic and Food Pattern Equivalent Database (FPED) data.
}
\examples{
\dontrun{
fped0910 <- get_fped("2009/2010", "both")
diet0910 <- get_diet("2009/2010", "both")
demo0910 <- get_demo("2009/2010")
hei(fped0910,diet0910,demo0910)

fped0506 <- get_fped("2005/2006", "first")
diet0506 <- get_diet("2005/2006", "first")
demo0506 <- get_demo("2005/2006")
hei(fped0506,diet0506,demo0506, agethresh = 18)
}
}
\references{
\url{https://www.cnpp.usda.gov/healthyeatingindex}
}
