% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{plot.surv_obj}
\alias{plot.surv_obj}
\title{Plot general survival models}
\usage{
\method{plot}{surv_obj}(x, times, type = c("surv", "prob"),
  join_col = "red", join_pch = 20, join_size = 3, ...)
}
\arguments{
\item{x}{a survival object of class \code{surv_aft}, \code{surv_add_haz},
\code{surv_ph}, \code{surv_po}, \code{surv_model}, \code{surv_pooled}, or \code{surv_projection}.}

\item{times}{Times at which to evaluate and plot the survival object.}

\item{type}{either \code{surv} (the default) or \code{prob}, depending on whether
you want to plot survival from the start or conditional probabilities.}

\item{join_col, join_pch, join_size}{graphical parameters for points
marking points at which different survival functions are joined.}

\item{...}{additional arguments to pass to \code{ggplot2} functions.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plot general survival models
}
\details{
The function currently only highlights join points that are at
the top level; that is, for objects with class \code{surv_projection}.

To avoid plotting the join points, set join_size to a negative number.
}
