% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamp_define.R
\name{define_distrib}
\alias{define_distrib}
\alias{define_distrib_}
\title{Define Parameters Distribution for Probabilistic Analysis}
\usage{
define_distrib(..., correlation)

define_distrib_(list_qdist, list_multi, correlation)
}
\arguments{
\item{...}{Formulas defining parameter distributions.}

\item{correlation}{A correlation matrix for parameters or
the output of \code{\link{define_correlation}}.}

\item{list_qdist}{List of resampling functions.}

\item{list_multi}{List of multinomial parameters.}
}
\value{
An object of class \code{resamp_definition}. 
  Contains \code{list_qdist}, a list of quantile 
  functions and \code{correlation} a correlation matrix.
}
\description{
Define the properties of parameter distributions and 
their correlation structure for probabilistic uncertainty
analysis of Markov models.
}
\details{
If no correlation matrix is specified parameters are 
assumed to be independant.

The correlation patrix need only be specified for 
correlated parameters.
}
\examples{
mc <- define_correlation(
  age_init, cost_init, .4
)

define_distrib(
    age_init ~ normal(60, 10),
    cost_init ~ normal(1000, 100),
    correlation = mc
)

# example with multinomial parameters

define_distrib(
  rate1 + rate2 + rate3 ~ multinom(10, 50, 40),
  a + b ~ multinom(15, 30)
)
}

