#' Evaluate Markov Model States
#' 
#' @param x An \code{uneval_state_list} object generated by 
#'   \code{\link{define_state_list}}.
#' @param parameters An \code{eval_parameters} object 
#'   generated by \code{\link{eval_parameters}}.
#'   
#' @return An \code{eval_states} object, a list with one
#'   data.frame per state containing a column per state
#'   value and a line per cycle.
#' 
eval_state_list <- function(x, parameters) {
  
  f <- function(x) {
    # bottleneck!
    dplyr::mutate_(parameters, .dots = x)[c("markov_cycle",
                                            names(x))]
  }
  
  res <- lapply(x, f)
  
  structure(res,
            class = c("eval_state_list", class(res)))
}

get_state_value_names.eval_state_list <- function(x){
  names(x[[1]])[-1]
}
