% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model_define.R
\name{run_models}
\alias{run_models}
\alias{run_models_}
\title{Run one or more Markov Model}
\usage{
run_models(..., parameters = define_parameters(), init = c(1000L, rep(0L,
  get_state_number(get_states(list(...)[[1]])) - 1)), cycles = 1,
  method = c("beginning", "end", "half-cycle", "life-table"), cost, effect,
  base_model = NULL)

run_models_(list_models, parameters, init, cycles, method, cost, effect,
  base_model)
}
\arguments{
\item{...}{One or more \code{uneval_model} object.}

\item{parameters}{Optional. An object generated by 
\code{\link{define_parameters}}.}

\item{init}{numeric vector, same length as number of 
model states. Number of individuals in each model state
at the beginning.}

\item{cycles}{positive integer. Number of Markov Cycles 
to compute.}

\item{method}{Counting method.}

\item{cost}{Names or expression to compute cost on the
cost-effectiveness plane.}

\item{effect}{Names or expression to compute effect on
the cost-effectiveness plane.}

\item{base_model}{Name of base model used as reference.
By default the model with the lowest effectiveness.}

\item{list_models}{List of models, only used by 
\code{run_models_} to avoid using \code{...}.}
}
\value{
A list of evaluated models with computed values.
}
\description{
Runs one or more unevaluated Markov Models. When more 
than one model is provided, all models should have the 
same states and state value names.
}
\details{
A usual situation where more than one model needs to be 
run is when comparing different care startegies.

In order to compute comparisons Markov Models must be 
similar (same states and state value names). Thus models 
should only differ through parameters, transition matrix 
cell values and values attached to states (but not state 
value names).

The initial number of individuals in each state and the 
number of cycle will be the same for all models.

Internally this function does 2 operations: first 
evaluating parameters, transition matrix, state values 
and computing individual counts through 
\code{\link{eval_model}}; and then using individual 
counts and evaluated state values to compute values at 
each cycle through \code{compute_values}.
}
\examples{
# running a single model

mod1 <-
  define_model(
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 543,
      ly = 1
    ),
    define_state(
      cost = 432,
      ly = 1
    )
  )


res <- run_models(
  mod1,
  init = c(100, 0),
  cycles = 2,
  cost = cost,
  effect = ly
)

# running several models
mod2 <-
  define_model(
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 789,
      ly = 1
    ),
    define_state(
      cost = 456,
      ly = 1
    )
    
  )


res2 <- run_models(
  mod1, mod2,
  init = c(100, 0),
  cycles = 10,
  cost = cost,
  effect = ly
)
}

