% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newdata.R
\name{eval_strategy_newdata}
\alias{eval_strategy_newdata}
\title{Iteratively Evaluate a Markov Model With New Parameter
Values}
\usage{
eval_strategy_newdata(x, strategy = 1, newdata)
}
\arguments{
\item{x}{Result from \code{\link[=run_model]{run_model()}}.}

\item{newdata}{a data.frame whose names match parameters
names. \code{model} will be evaluated iteratively,
taking successive values from each row.}

\item{model}{Name or index of model to recompute.}
}
\value{
A data.frame containing the values of
\code{newdata} and each Markov Model evaluation in
\code{res}.
}
\description{
Given a data.frame with on set of new parameters values
per row, iteratively evaluate the model over the set of
new values.
}
\details{
New parameters with a missing value (\code{NA}) do not
replace existing parameters.
}
\examples{
par1 <- define_parameters(
  a = 1,
  b = 1 / (markov_cycle + a)
)

mat1 <- define_transition(
  1-b, b,
  0, 1
)
mod1 <- define_strategy(
  transition = mat1,
  define_state(var = a),
  define_state(var = a * markov_cycle)
)

res1 <- run_model(
  mod1,
  parameters = par1,
  cycles = 5,
  init = 1:0,
  method = "end"
)

new_tab <- data.frame(
  a = 1:10
)

heemod:::eval_strategy_newdata(
  res1,
  newdata = new_tab
)
}
\keyword{internal}
