% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{define_calibration_fn}
\alias{define_calibration_fn}
\title{Define Calibration Function}
\usage{
define_calibration_fn(
  type,
  strategy_names,
  element_names,
  cycles,
  groups = NULL,
  aggreg_fn = sum
)
}
\arguments{
\item{type}{Type of model values (\code{count} or \code{value}).}

\item{strategy_names}{Names of strategies.}

\item{element_names}{Names of states (for counts) or of
state values (for values).}

\item{cycles}{Cycles of interest.}

\item{groups}{Optional grouping of values (values in a
same group have the same \code{groups}).}

\item{aggreg_fn}{A function to aggregate values in a same
group.}
}
\value{
A numeric vector.
}
\description{
Define a function to be passed to the \code{fn_values}
argument of \code{\link[=calibrate_model]{calibrate_model()}}.
}
\examples{
example("run_model")

f <- define_calibration_fn(
  type = c("count", "count", "value"),
  strategy_names = c("I", "I", "II"),
  element_names = c("A", "B", "ly"),
  cycles = c(3, 5, 9),
  groups = c(1, 1, 2),
  aggreg_fn = mean
)

}
