% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_parameters.R
\name{use_parameters}
\alias{use_parameters}
\title{Automatically include session objects as report parameters}
\usage{
use_parameters(template, ..., init.params = TRUE, is.file = FALSE)
}
\arguments{
\item{template}{An atomic (\code{length(template) == 1}) character vector
containing either the template to manipulate OR the path to the file storing
the template, which will be imported via import_pattern.}

\item{...}{Objects to be included as parameters. Objects should be unquoted
and exist in the current session environment. This function currently will
always assign parameters NA as a default value, and does not yet provide an
option to override that.}

\item{init.params}{A boolean (\code{TRUE/FALSE}) value indicating if
a chunk initalizing the parameters (that is, assigning them via
\code{object <- params$object}) should be included. Default \code{TRUE}.}

\item{is.file}{A boolean value indicating if the template argument is a
vector containing the template (\code{FALSE}, default) or the path to the
template file (\code{TRUE}).}
}
\description{
R Markdown documents allow you to pass almost any object -- including large
data frames and functions -- to the document as parameters, letting you
only define them once to use them in both your document generator and
the generated document. This function makes it slightly easier to do so,
by adding your objects to the YAML header and then initializing them
so you can use the same object names in your generated document as in your
generator.
}
\examples{
template <- make_template("---\ntitle: Cool Report\noutput: html_document\n---\n")
use_parameters(template, data)
}
\seealso{
Other manipulation functions: 
\code{\link{create_yaml_header}()},
\code{\link{heddle}()},
\code{\link{make_template}()}
}
\concept{manipulation functions}
