% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-adf-test.R
\name{ts_adf_test}
\alias{ts_adf_test}
\title{Augmented Dickey-Fuller Test for Time Series Stationarity}
\usage{
ts_adf_test(.x, .k = NULL)
}
\arguments{
\item{.x}{A numeric vector representing the time series to be tested for
stationarity.}

\item{.k}{An optional parameter specifying the number of lags to use in the
ADF test (default is calculated).}
}
\value{
A list containing the results of the Augmented Dickey-Fuller test:
\itemize{
\item \code{test_stat}: The test statistic from the ADF test.
\item \code{p_value}: The p-value of the test.
}
}
\description{
This function performs the Augmented Dickey-Fuller test to assess the
stationarity of a time series. The Augmented Dickey-Fuller (ADF) test is used
to determine if a given time series is stationary. This function takes a
numeric vector as input, and you can optionally specify the lag order with
the \code{.k} parameter. If \code{.k} is not provided, it is calculated based on the
number of observations using a formula. The test statistic and p-value are
returned.
}
\examples{
# Example 1: Using the AirPassengers dataset
ts_adf_test(AirPassengers)

# Example 2: Using a custom time series vector
custom_ts <- rnorm(100, 0, 1)
ts_adf_test(custom_ts)

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Statistical Test}
