% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-sma-plot.R
\name{ts_sma_plot}
\alias{ts_sma_plot}
\title{Simple Moving Average Plot}
\usage{
ts_sma_plot(
  .data,
  .sma_order = 2,
  .func = mean,
  .align = "center",
  .partial = FALSE
)
}
\arguments{
\item{.data}{The data that you are passing, this can be either a \code{ts} object or a \code{tibble}}

\item{.sma_order}{This will default to 1. This can be a vector like c(2,4,6,12)}

\item{.func}{The unquoted function you want to pass, mean, median, etc}

\item{.align}{This can be either "left", "center", "right"}

\item{.partial}{This is a bool value of TRUE/FALSE, the default is TRUE}
}
\value{
Will invisibly return a list object.
}
\description{
This function will take in a value column and return any number \code{n} moving averages.
}
\details{
This function will accept a time series object or a tibble/data.frame. This is a
simple wrapper around \code{\link[timetk:slidify_vec]{timetk::slidify_vec()}}. It uses that function to do the underlying
moving average work. Since the function \code{\link[=ts_to_tbl]{ts_to_tbl()}} is called
there is no need to supply a value column. This function will only work on a single
value column

It can only handle a single moving average at a time and therefore if multiple
are called for, it will loop through and append data to a tibble or \code{ts} object.
}
\examples{
out <- ts_sma_plot(AirPassengers, .sma_order = c(3,6))

out$data

out$plots$static_plot

out$plots$interactive_plot

}
\author{
Steven P. Sanderson II, MPH
}
