% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl-cur-hosp-data.R
\name{current_hosp_data}
\alias{current_hosp_data}
\title{Download Current Hospital Data Files.}
\usage{
current_hosp_data(path = utils::choose.dir())
}
\arguments{
\item{path}{The location to download and unzip the files}
}
\value{
Downloads the current hospital data sets.
}
\description{
Download the current Hospital Data Sets.
}
\details{
This function will download the current and the official hospital
data sets from the \strong{CMS.gov} website.

The function makes use of a temporary directory and file to save and unzip
the data. This will grab the current Hospital Data Files, unzip them and
return a list of tibbles with each tibble named after the data file.

The function returns a list object with all of the current hospital data as a
tibble. It does not save the data anywhere so if you want to save it you will
have to do that manually.

This also means that you would have to store the data as a variable in order
to access the data later on. It does have a given attributes and a class so
that it can be piped into other functions.
}
\examples{
\dontrun{
  current_hosp_data()
}

}
\seealso{
\url{https://data.cms.gov/provider-data/topics/hospitals/}

Other Hospital Data: 
\code{\link{current_asc_data}()},
\code{\link{current_asc_oas_cahps_data}()},
\code{\link{current_comp_death_data}()},
\code{\link{current_hai_data}()},
\code{\link{current_hcahps_data}()},
\code{\link{current_hvbp_data}()},
\code{\link{current_ipfqr_data}()},
\code{\link{current_maternal_data}()},
\code{\link{current_medicare_hospital_spending_data}()},
\code{\link{current_oqr_oas_cahps_data}()},
\code{\link{current_outpatient_imaging_efficiency_data}()},
\code{\link{current_payments_data}()},
\code{\link{current_pch_hai_hospital_data}()},
\code{\link{current_pch_hcahps_data}()},
\code{\link{current_pch_oncology_measures_hospital_data}()},
\code{\link{current_pch_outcomes_data}()},
\code{\link{current_timely_and_effective_care_data}()},
\code{\link{current_unplanned_hospital_visits_data}},
\code{\link{current_va_data}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Hospital Data}
