% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-data-trig.R
\name{hai_data_trig}
\alias{hai_data_trig}
\title{Data Preprocessor - Trigonometric Functions}
\usage{
hai_data_trig(
  .recipe_object = NULL,
  ...,
  .type_of_scale = "sinh",
  .inverse = FALSE
)
}
\arguments{
\item{.recipe_object}{The data that you want to process}

\item{...}{One or more selector functions to choose variables to be imputed.
When used with imp_vars, these dots indicate which variables are used to
predict the missing data in each variable. See selections() for more details}

\item{.type_of_scale}{This is a quoted argument and can be one of the following:
\itemize{
\item "sinh"
\item "cosh"
\item "tanh"
}}

\item{.inverse}{A logical: should the inverse function be used? Default is FALSE}
}
\value{
A list object
}
\description{
Takes in a recipe and will scale values using a selected recipe. To call the
recipe use a quoted argument like "sinh", "cosh" or "tanh". This function
is not exported but may be called via the ::: method.
}
\details{
This function will get your data ready for processing with many types of ml/ai
models.

This is intended to be used inside of the data processor and
therefore is an internal function. This documentation exists to explain the process
and help the user understand the parameters that can be set in the pre-processor function.

\code{\link[recipes:step_hyperbolic]{recipes::step_hyperbolic()}}
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

date_seq <- seq.Date(from = as.Date("2013-01-01"), length.out = 100, by = "month")
val_seq <- rep(rnorm(10, mean = 6, sd = 2), times = 10)
df_tbl <- tibble(
  date_col = date_seq,
  value    = val_seq
)

rec_obj <- recipe(value ~ ., df_tbl)

healthyR.ai:::hai_data_trig(
  .recipe_object = rec_obj,
  value,
  .type_of_scale = "sinh"
)$scale_rec_obj \%>\%
  get_juiced_data()

}
\seealso{
\url{https://recipes.tidymodels.org/reference/step_hyperbolic.html}

Other Data Recipes: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{pca_your_recipe}()}

Other Preprocessor: 
\code{\link{hai_c50_data_prepper}()},
\code{\link{hai_cubist_data_prepper}()},
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_earth_data_prepper}()},
\code{\link{hai_glmnet_data_prepper}()},
\code{\link{hai_knn_data_prepper}()},
\code{\link{hai_ranger_data_prepper}()},
\code{\link{hai_svm_poly_data_prepper}()},
\code{\link{hai_svm_rbf_data_prepper}()},
\code{\link{hai_xgboost_data_prepper}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Preprocessor}
