% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-data-impute-missing.R
\name{hai_data_impute}
\alias{hai_data_impute}
\title{Data Preprocessor - Imputation}
\usage{
hai_data_impute(
  .recipe_object = NULL,
  ...,
  .seed_value = 123,
  .type_of_imputation = "mean",
  .number_of_trees = 25,
  .neighbors = 5,
  .mean_trim = 0,
  .roll_statistic,
  .roll_window = 5
)
}
\arguments{
\item{.recipe_object}{The data that you want to process}

\item{...}{One or more selector functions to choose variables to be imputed.
When used with imp_vars, these dots indicate which variables are used to
predict the missing data in each variable. See selections() for more details}

\item{.seed_value}{To make results reproducible, set the seed.}

\item{.type_of_imputation}{This is a quoted argument and can be one of the following:
\itemize{
\item "bagged"
\item "knn"
\item "linear"
\item "lower"
\item "mean"
\item "median"
\item "mode"
\item "roll"
}}

\item{.number_of_trees}{This is used for the \code{\link[recipes:step_impute_bag]{recipes::step_impute_bag()}} trees
parameter. This should be an integer.}

\item{.neighbors}{This should be filled in with an integer value if \code{.type_of_imputation}
selected is "knn".}

\item{.mean_trim}{This should be filled in with a fraction if \code{.type_of_imputation}
selected is "mean".}

\item{.roll_statistic}{This should be filled in with a single unquoted function
that takes with it a single argument such as mean. This should be filled in
if \code{.type_of_imputation} selected is "roll".}

\item{.roll_window}{This should be filled in with an integer value if \code{.type_of_imputation}
selected is "roll".}
}
\value{
A list object
}
\description{
Takes in a recipe and will impute missing values using a selected recipe.
To call the recipe use a quoted argument like "median" or "bagged". This function
is not exported but may be called via the ::: method.
}
\details{
This function will get your data ready for processing with many types of ml/ai
models.

This is intended to be used inside of the data processor and
therefore is an internal function. This documentation exists to explain the process
and help the user understand the parameters that can be set in the pre-processor function.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

date_seq <- seq.Date(from = as.Date("2013-01-01"), length.out = 100, by = "month")
val_seq  <- rep(c(rnorm(9), NA), times = 10)
df_tbl   <- tibble(
    date_col = date_seq,
    value    = val_seq
)

rec_obj <- recipe(value ~., df_tbl)

healthyR.ai:::hai_data_impute(
    .recipe_object = rec_obj,
    value,
    .type_of_imputation = "roll",
.roll_statistic = median
)$impute_rec_obj \%>\%
    get_juiced_data()

}
\seealso{
\url{https://recipes.tidymodels.org/reference/index.html#section-step-functions-imputation/}

step_impute_bag

\code{\link[recipes:step_impute_bag]{recipes::step_impute_bag()}}

\url{https://recipes.tidymodels.org/reference/step_impute_bag.html}

step_impute_knn

\code{\link[recipes:step_impute_knn]{recipes::step_impute_knn()}}

\url{https://recipes.tidymodels.org/reference/step_impute_knn.html}

step_impute_linear

\code{\link[recipes:step_impute_linear]{recipes::step_impute_linear()}}

\url{https://recipes.tidymodels.org/reference/step_impute_linear.html}

step_impute_lower

\code{\link[recipes:step_impute_lower]{recipes::step_impute_lower()}}

\url{https://recipes.tidymodels.org/reference/step_impute_lower.html}

step_impute_mean

\code{\link[recipes:step_impute_mean]{recipes::step_impute_mean()}}

\url{https://recipes.tidymodels.org/reference/step_impute_mean.html}

step_impute_median

\code{\link[recipes:step_impute_median]{recipes::step_impute_median()}}

\url{https://recipes.tidymodels.org/reference/step_impute_median.html}

step_impute_mode

\code{\link[recipes:step_impute_mode]{recipes::step_impute_mode()}}

\url{https://recipes.tidymodels.org/reference/step_impute_mode.html}

step_impute_roll

\code{\link[recipes:step_impute_roll]{recipes::step_impute_roll()}}

\url{https://recipes.tidymodels.org/reference/step_impute_roll.html}

Other Data Recipes: 
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{pca_your_recipe}()}

Other Preprocessor: 
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Preprocessor}
\keyword{internal}
