% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-skewness.R
\name{hai_skewness_vec}
\alias{hai_skewness_vec}
\title{Compute Skewness of a Vector}
\usage{
hai_skewness_vec(.x)
}
\arguments{
\item{.x}{A numeric vector of length four or more.}
}
\value{
The skewness of a vector
}
\description{
This function takes in a vector as it's input and will return the skewness
of that vector. The length of this vector must be at least four numbers. The
skewness explains the 'tailedness' of the distribution of data.

\verb{((1/n) * sum(x - mu\})^3) / ((()1/n) * sum(x - mu)^2)^(3/2)}
}
\details{
A function to return the skewness of a vector.
}
\examples{
hai_skewness_vec(rnorm(100, 3, 2))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Skewness}

Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_kurtosis_vec}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_scale_zscore_vec}()},
\code{\link{hai_winsorized_move_vec}()},
\code{\link{hai_winsorized_truncate_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
