% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ti.R
\name{ti}
\alias{ti}
\title{Theil Index (TI)}
\usage{
ti(pop, est, se = NULL, conf.level = 0.95, ...)
}
\arguments{
\item{pop}{The number of people within each subgroup.
Population size must be available for all subgroups.}

\item{est}{The subgroup estimate. Estimates must be
available for all subgroups.}

\item{se}{The standard error of the subgroup estimate.
If this is missing, 95\% confidence intervals of TI cannot be calculated.}

\item{conf.level}{confidence level of the interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated TI value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The Theil Index (TI) is a relative measure of inequality that
considers all population subgroups. Subgroups are weighted
according to their population share.
}
\details{
TI is calculated as the sum of products of the natural logarithm
of the share of the indicator of each subgroup, the share of the
indicator of each subgroup and the population share of each subgroup.
TI may be easily interpreted when multiplied by 1000. For more
information on this inequality measure see
Schlotheuber, A., & Hosseinpoor, A. R. (2022) below.

\strong{Interpretation:} Greater absolute values indicate higher levels of
inequality. TI is zero if there is no inequality. TI is more sensitive
to differences further from the setting average (by the use of the
logarithm).

\strong{Type of summary measure:} Complex; relative; weighted

\strong{Applicability:} Non-ordered; more than two subgroups

\strong{Warning:} The confidence intervals are approximate
and might be biased.
}
\examples{
# example code
data(NonorderedSample)
head(NonorderedSample)
with(NonorderedSample,
     ti(pop = population,
        est = estimate,
        se = se
        )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.

Ahn J, Harper S, Yu M, Feuer EJ, Liu B, Luta G. Variance
Estimation and Confidence Intervals for 11 Commonly Used
Health Disparity Measures. JCO Clin Cancer Inform. 2018
Dec;2:1--19.
}
