% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgv.R
\name{bgv}
\alias{bgv}
\title{Between-group variance (BGV)}
\usage{
bgv(pop, est, se = NULL, conf.level = 0.95, ...)
}
\arguments{
\item{pop}{The number of people within each subgroup.
Population size must be available for all subgroups.}

\item{est}{The subgroup estimate. Estimates must be
available for all subgroups.}

\item{se}{The standard error of the subgroup estimate.
If this is missing, 95\% confidence intervals of BGV cannot be calculated.}

\item{conf.level}{confidence level of the interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated BGV value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
Between-Group Variance (BGV) is an absolute measure of inequality that
considers all population subgroups. Subgroups are weighted according to
their population share.
}
\details{
BGV is calculated as the weighted average of squared differences between
the subgroup estimates  and the setting average. Squared differences
are weighted by each subgroup’s population share. For more information
on this inequality measure see Schlotheuber, A., & Hosseinpoor, A. R.
(2022) below.

\strong{Interpretation:} BGV has only positive values, with larger values
indicating higher levels of inequality. BGV is zero if there is no
inequality.
BGV is more sensitive to outlier estimates as it gives more weight to the
estimates that are further from the setting average. It is reported as the
squared unit of the health indicator.

\strong{Type of summary measure:} Complex; absolute; weighted

\strong{Applicability:} Non-ordered; more than two subgroups

\strong{Warning:} The confidence intervals are approximate
and might be biased. See Ahn J. et al. (1978) below for
further information on the standard error formula.
}
\examples{
# example code
data(NonorderedSample)
head(NonorderedSample)
with(NonorderedSample,
     bgv(pop = population,
          est = estimate,
          se = se
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.

Ahn J, Harper S, Yu M, Feuer EJ, Liu B, Luta G. Variance
Estimation and Confidence Intervals for 11 Commonly Used
Health Disparity Measures. JCO Clin Cancer Inform. 2018
Dec;2:1--19.
}
