% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{findTrends}
\alias{findTrends}
\title{Find any columns that have a trend above a particular threshold}
\usage{
findTrends(df, dateCol, groupbyCol)
}
\arguments{
\item{df}{A data frame}

\item{dateCol}{A string denoting the date column}

\item{groupbyCol}{A string denoting the column by which to group}
}
\value{
A data frame containing the dimensional attribute (ie gender), the
subset the data was grouped by (ie M/F), the measures that had trends
(ie, mortality or readmission), and the ending month.
}
\description{
Find numeric columns in data frame that have an absolute slope greater than
that specified via threshold argument.
}
\examples{
dates <- c(as.Date('2012-01-01'),as.Date('2012-01-02'),as.Date('2012-02-01'),
          as.Date('2012-03-01'),as.Date('2012-04-01'),as.Date('2012-05-01'),
          as.Date('2012-06-01'),as.Date('2012-06-02'))
y1 <- c(0,1,2,6,8,13,14,16)               # large positive
y2 <- c(.8,1,1.2,1.2,1.2,1.3,1.3,1.5)     # small positive
y3 <- c(1,0,-2,-2,-4,-5,-7,-8)            # big negative
y4 <- c(.5,0,-.5,-.5,-.5,-.5,-.6,0)       # small negative
gender <- c('M','F','F','F','F','F','F','F')
df <- data.frame(dates,y1,y2,y3,y4,gender)

dfResult <- findTrends(df = df,
                      dateCol = 'dates',
                      groupbyCol = 'gender')
dfResult
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
