
<!-- README.md is generated from README.Rmd. Please edit that file -->

# healthcare.antitrust

<!-- badges: start -->
<!-- badges: end -->

The goal of healthcare.antitrust is to provide a set of tools commonly
used in the antitrust analysis of healthcare markets. The main functions
of the package can be used to implement the semiparametric estimation
technique described in Raval, Rosenbaum, and Tenn (2017) “A
Semiparametric Discrete Choice Model: An Application to Hospital
Mergers.”

Users of the statistical software Stata can use the [Stata module
“divratio”](https://econpapers.repec.org/software/bocbocode/S459169.htm)
available from the SSC repository to implement many of these same tools.

## Installation

You can install the released version of healthcare.antitrust from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("healthcare.antitrust")
```

And the development version from [GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("mpanhans/healthcare.antitrust")
```

## Example

See the package vignette for examples:

``` r
vignette("semipar_example", package = "healthcare.antitrust")
```

# Disclaimer

<!-- This software contains materials that originally came from the U.S. Federal Trade Commission (FTC) and is in the public domain. -->
<!-- No warranty, expressed or implied, is made by the authors or the FTC as to the the accuracy and functioning of the program and related program material nor shall the fact of distribution constitute any such warranty, and no responsibility is assumed by the authors or the FTC in connection therewith. -->

Any views expressed in this software or documentation are those of the
authors and do not necessarily reflect those of the Federal Trade
Commission or any individual Commissioner.

<!-- What is special about using `README.Rmd` instead of just `README.md`? You can include R chunks like so: -->
<!-- ```{r cars} -->
<!-- summary(cars) -->
<!-- ``` -->
<!-- You'll still need to render `README.Rmd` regularly, to keep `README.md` up-to-date. -->
<!-- You can also embed plots, for example: -->
<!-- ```{r pressure, echo = FALSE} -->
<!-- plot(pressure) -->
<!-- ``` -->
<!-- In that case, don't forget to commit and push the resulting figure files, so they display on GitHub! -->
