% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ha_data.R
\name{ha_data}
\alias{ha_data}
\title{Obtain Data}
\usage{
ha_data(
  topic_key,
  population_key,
  period_key,
  layer_key,
  geometry = FALSE,
  progress = TRUE
)
}
\arguments{
\item{topic_key}{Character string or vector of
Unique IDs(s) specifying topic(s).}

\item{population_key}{Character string or vector of
Unique ID(s) for population stratification(s).}

\item{period_key}{Character string or vector of
Unique ID(s) for time period(s).}

\item{layer_key}{Character string specifying an
Unique ID for a geographic layer.}

\item{geometry}{Attach geometry to output?}

\item{progress}{Display a progress bar?}
}
\value{
Data tibble containing value and standard
error for each topic measure.
}
\description{
Obtain data for one or more topics within specified
populations for specified time periods and geographic
scale.

All combinations of topic, population, period, and layer
will be returned. Warnings will be generated for any
invalid combinations.
}
\examples{
\donttest{
ha_set("chicagohealthatlas.org")

ha_data("POP", "H", "2014-2018", "zip")
}
}
