% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdsvmcv.R
\name{cv.hdsvm}
\alias{cv.hdsvm}
\title{Cross-validation for Selecting the Tuning Parameter in the Penalized SVM}
\usage{
cv.hdsvm(x, y, lambda = NULL, nfolds = 5L, foldid, ...)
}
\arguments{
\item{x}{A numerical matrix with \eqn{n} rows (observations) and \eqn{p} columns (variables).}

\item{y}{Response variable.}

\item{lambda}{Optional; a user-supplied sequence of \code{lambda} values. If \code{NULL}, 
\code{\link{hdsvm}} selects its own sequence.}

\item{nfolds}{Number of folds for cross-validation. Defaults to 5.}

\item{foldid}{Optional vector specifying the indices of observations in each fold.
If provided, it overrides \code{nfolds}.}

\item{...}{Additional arguments passed to \code{\link{hdsvm}}.}
}
\value{
An object with S3 class \code{cv.hdsvm} consisting of
  \item{lambda}{Candidate \code{lambda} values.}
  \item{cvm}{Mean cross-validation error.}
  \item{cvsd}{Standard error of the mean cross-validation error.}
  \item{cvup}{Upper confidence curve: \code{cvm} + \code{cvsd}.}
  \item{cvlo}{Lower confidence curve: \code{cvm} - \code{cvsd}.}
  \item{lambda.min}{\code{lambda} achieving the minimum cross-validation error.}
  \item{lambda.1se}{Largest \code{lambda} within one standard error of the minimum error.}
  \item{cv.min}{Cross-validation error at \code{lambda.min}.}
  \item{cv.1se}{Cross-validation error at \code{lambda.1se}.}
  \item{hdsvm.fit}{a fitted \code{\link{hdsvm}} object for the full data.}
  \item{nzero}{Number of non-zero coefficients at each \code{lambda}.}
}
\description{
Performs k-fold cross-validation for \code{\link{hdsvm}}, similar to \code{\link[glmnet]{cv.glmnet}}.
}
\details{
This function computes the average cross-validation error and provides the standard error.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
lam2 <- 0.01
fit <- cv.hdsvm(x, y, lam2=lam2)
}
\keyword{classification}
\keyword{models}
