% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassotreatment.R
\name{rlassoATE}
\alias{rlassoATE}
\alias{late}
\alias{latet}
\alias{ate}
\alias{atet}
\alias{LATE}
\alias{LATET}
\alias{ATE}
\alias{ATET}
\alias{rlassoATE.default}
\alias{rlassoATE.formula}
\alias{rlassoATET}
\alias{rlassoATET.default}
\alias{rlassoATET.formula}
\alias{rlassoLATE}
\alias{rlassoLATE.default}
\alias{rlassoLATE.formula}
\alias{rlassoLATET}
\alias{rlassoLATET.default}
\alias{rlassoLATET.formula}
\title{Functions for estimation of treatment effects}
\usage{
rlassoATE(x, ...)

\method{rlassoATE}{default}(x, d, y, bootstrap = "none", nRep = 500, ...)

\method{rlassoATE}{formula}(formula, data, bootstrap = "none", nRep = 500,
  ...)

rlassoATET(x, ...)

\method{rlassoATET}{default}(x, d, y, bootstrap = "none", nRep = 500, ...)

\method{rlassoATET}{formula}(formula, data, bootstrap = "none", nRep = 500,
  ...)

rlassoLATE(x, ...)

\method{rlassoLATE}{default}(x, d, y, z, bootstrap = "none", nRep = 500,
  post = TRUE, intercept = TRUE, always_takers = TRUE,
  never_takers = TRUE, ...)

\method{rlassoLATE}{formula}(formula, data, bootstrap = "none", nRep = 500,
  post = TRUE, intercept = TRUE, always_takers = TRUE,
  never_takers = TRUE, ...)

rlassoLATET(x, ...)

\method{rlassoLATET}{default}(x, d, y, z, bootstrap = "none", nRep = 500,
  post = TRUE, intercept = TRUE, always_takers = TRUE, ...)

\method{rlassoLATET}{formula}(formula, data, bootstrap = "none", nRep = 500,
  post = TRUE, intercept = TRUE, always_takers = TRUE, ...)
}
\arguments{
\item{x}{exogenous variables}

\item{...}{arguments passed, e.g. \code{intercept} and \code{post}}

\item{d}{treatment variable (binary)}

\item{y}{outcome variable / dependent variable}

\item{bootstrap}{boostrap method which should be employed: 'none', 'Bayes',
'normal', 'wild'}

\item{nRep}{number of replications for the bootstrap}

\item{formula}{An object of class \code{Formula} of the form " y ~ x + d | x" with y the outcome variable,
d treatment variable, and x exogenous variables.}

\item{data}{An optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which \code{rlassoATE} is called.}

\item{z}{instrumental variables (binary)}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{intercept}{logical. If \code{TRUE}, intercept is included which is not}

\item{always_takers}{option to adapt to cases with (default) and without always-takers. If \code{FALSE}, the estimator is adapted to a setting without always-takers.}

\item{never_takers}{option to adapt to cases with (default) and without never-takers. If \code{FALSE}, the estimator is adapted to a setting without never-takers.}
}
\value{
Functions return an object of class \code{rlassoTE} with estimated effects, standard errors and
individual effects in the form of a \code{list}.
}
\description{
This class of functions estimates the average treatment effect (ATE), the ATE of the tretated (ATET), the local average treatment effects (LATE) and the LATE of
the tretated (LATET). The estimation methods rely on immunized / orthogonal moment
conditions which guarantee valid post-selection inference in a high-dimensional setting. Further details can be found in Belloni et al. (2014).
}
\details{
Details can be found in Belloni et al. (2014).
}
\references{
A. Belloni, V. Chernozhukov, I. Fernandez-Val, and C. Hansen
(2014). Program evaluation with high-dimensional data. Working Paper.
}
