% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassologit.R
\name{rlassologit}
\alias{rlassologit}
\alias{rlassologit.default}
\alias{rlassologit.formula}
\title{rlassologit: Function for logistic Lasso estimation}
\usage{
rlassologit(x, ...)

\method{rlassologit}{formula}(formula, data, post = TRUE, intercept = TRUE,
  model = TRUE, penalty = list(lambda = NULL, c = 1.1, gamma = 0.1/log(n)),
  control = list(threshold = NULL), ...)

\method{rlassologit}{default}(x, y, post = TRUE, intercept = TRUE,
  model = TRUE, penalty = list(lambda = NULL, c = 1.1, gamma = 0.1/log(n)),
  control = list(threshold = NULL), ...)
}
\arguments{
\item{x}{regressors (matrix)}

\item{...}{further parameters passed to glmnet}

\item{formula}{an object of class 'formula' (or one that can be coerced to
that class): a symbolic description of the model to be fitted in the form
\code{y~x}.}

\item{data}{an optional data frame, list or environment.}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{intercept}{logical. If \code{TRUE}, intercept is included which is not
penalized.}

\item{model}{logical. If \code{TRUE} (default), model matrix is returned.}

\item{penalty}{list with options for the calculation of the penalty.  \code{c} and \code{gamma} constants for the penalty.}

\item{control}{list with control values.
\code{threshold} is applied to the final estimated lasso
coefficients. Absolute values below the threshold are set to zero.}

\item{y}{dependent variable (vector or matrix)}
}
\value{
\code{rlassologit} returns an object of class
\code{rlassologit}. An object of class \code{rlassologit} is a list
containing at least the following components: \item{coefficients}{parameter
estimates} \item{beta}{parameter
estimates (without intercept)} \item{intercept}{value of intercept} \item{index}{index of selected variables (logicals)}
\item{lambda}{penalty term}
\item{residuals}{residuals}
\item{sigma}{root of the variance of the residuals}
\item{call}{function call}
\item{options}{options}
}
\description{
The function estimates the coefficients of a logistic Lasso regression with
data-driven penalty. The method of the data-driven penalty can be chosen.
The object which is returned is of the S3 class \code{rlassologit}
}
\details{
The function estimates the coefficients of a Logistic Lasso regression with
data-driven penalty. The
option \code{post=TRUE} conducts post-lasso estimation, i.e. a refit of the
model with the selected variables.
}
\examples{
\dontrun{
library(hdm)
## DGP
set.seed(2)
n <- 250
p <- 100
px <- 10
X <- matrix(rnorm(n*p), ncol=p)
beta <- c(rep(2,px), rep(0,p-px))
intercept <- 1
P <- exp(intercept + X \%*\% beta)/(1+exp(intercept + X \%*\% beta))
y <- rbinom(length(y), size=1, prob=P)
## fit rlassologit object
 rlassologit.reg <- rlassologit(y~X)
 ## methods
summary(rlassologit.reg, all=F)
print(rlassologit.reg)
predict(rlassologit.reg, type='response')
X3 <- matrix(rnorm(n*p), ncol=p)
predict(rlassologit.reg, newdata=X3)
}
}
\references{
Belloni, A., Chernozhukov and Y. Wei (2013). Honest confidence regions for logistic regression with a large number of controls. arXiv preprint arXiv:1304.3969.
}
\keyword{lasso}
\keyword{logistic}
\keyword{regression}

