% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.r
\name{hql_file}
\alias{hql_file}
\alias{hql_use_file}
\alias{hql_close_file}
\title{Access HDF Files}
\usage{
hql_use_file(file)

hql_close_file(file, all = FALSE)
}
\arguments{
\item{file}{The HDF file path.}

\item{all}{If \code{TRUE}, close all open HDF files.}
}
\description{
Open (use) and close HDF files.
}
\section{Functions}{
\itemize{
\item \code{hql_use_file}: Open (use) an HDF file.

\item \code{hql_close_file}: Close an HDF file.
}}

\examples{
if(hql_is_loaded()){
  tf = tempfile(fileext = ".h5")
  hql_create_file(tf)

  hql_use_file(tf)
  hql_flush()

  hql_close_file(tf)
}

}
