% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5P.R
\docType{class}
\name{H5P-class}
\alias{H5P-class}
\alias{H5P}
\title{Class for HDF5 property lists.}
\value{
Object of class \code{\link{H5P}}.
}
\description{
This is the base class for all property lists, but most have a specialized class.
It inherits all functions of the
\code{\link{H5RefClass}}. It is also the base class for many other classes, specifically
\describe{
\item{Dataset Creation}{\code{\link{H5P_DATASET_CREATE}}}
\item{Dataset Access}{\code{\link{H5P_DATASET_ACCESS}}}
\item{Dataset Transfer}{\code{\link{H5P_DATASET_XFER}}}
\item{Link Creation}{\code{\link{H5P_LINK_CREATE}}}
\item{Link Access}{\code{\link{H5P_LINK_ACCESS}}}
\item{Object Creation}{\code{\link{H5P_OBJECT_CREATE}}}
\item{Object Copy}{\code{\link{H5P_OBJECT_COPY}}}
\item{Attribute Creation}{\code{\link{H5P_ATTRIBUTE_CREATE}}}
}
The base class is unlikely to be needed by users - they should use the appropriate subclass required.
}
\section{Methods}{

\describe{
\item{\code{new(id = NULL)}}{

Create a new property list; this function itself is unlikely to be needed by users. Users should
use the classes of the type they actually require

\strong{Parameters}
\describe{
\item{id}{Internal use only}
}}

\item{\code{get_class()}}{

This function implements the HDF5-API function H5Pget_class.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5P.html#Property-GetClass} for details.}

\item{\code{get_class_name()}}{

This function implements the HDF5-API function H5Pget_class_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5P.html#Property-GetClassName} for details.}

\item{\code{copy()}}{

This function implements the HDF5-API function H5Pcopy.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5P.html#Property-Copy} for details.}

\item{\code{equal(cmp)}}{

This function implements the HDF5-API function H5Pequal.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5P.html#Property-Equal} for details.}
}}

\examples{
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")
file[["testdataset"]] <- 1:10
p <- file[["testdataset"]]$get_create_plist()
p$get_class()
p$get_class_name()
p$copy()
p$equal(p)
file$close_all()
}
\author{
Holger Hoefling
}
