% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRDC.R
\name{catalogueGRDC}
\alias{catalogueGRDC}
\title{Data source: Global Runoff Data Centre catalogue}
\usage{
catalogueGRDC()
}
\value{
This function returns a data frame made with the following columns:
\itemize{
  \item{\code{grdc_no}}{: GRDC station number}
  \item{\code{wmo_reg}}{: WMO region}
  \item{\code{sub_reg}}{: WMO subregion}
  \item{\code{river}}{: river name}
  \item{\code{station}}{: station name}
  \item{\code{country}}{: 2-letter country code (ISO 3166)}
  \item{\code{lat}}{: latitude, decimal degree}
  \item{\code{long}}{: longitude, decimal degree}
  \item{\code{area}}{: catchment size, km2}
  \item{\code{altitude}}{: height of gauge zero, m above sea level}
  \item{\code{d_start}}{: daily data available from year}
  \item{\code{d_end}}{: daily data available until year}
  \item{\code{d_yrs}}{: length of time series, daily data}
  \item{\code{d_miss}}{: percentage of missing values (daily data)}
  \item{\code{m_start}}{: monthly data available from}
  \item{\code{m_end}}{: monthly data available until}
  \item{\code{m_yrs}}{: length of time series, monthly data}
  \item{\code{m_miss}}{: percentage of missing values (monthly data)}
  \item{\code{t_start}}{: earliest data available}
  \item{\code{t_end}}{: latest data available}
  \item{\code{t_yrs}}{: maximum length of time series, daily and monthly
  data}
  \item{\code{lta_discharge}}{: mean annual streamflow, m3/s}
  \item{\code{r_volume_yr}}{: mean annual volume, km3}
  \item{\code{r_height_yr}}{: mean annual runoff depth, mm}
}
}
\description{
This function interfaces the Global Runoff Data Centre database
which provides river discharge data for almost 1000 sites over 157 countries.
}
\examples{
\dontrun{
  # Retrieve the catalogue
  GRDC_catalogue_all <- catalogueGRDC()
}

}
\author{
Claudia Vitolo
}
