% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOPEX.R
\name{catalogueMOPEX}
\alias{catalogueMOPEX}
\title{Data source: MOPEX catalogue}
\source{
https://hydrology.nws.noaa.gov/pub/gcip/mopex/US_Data/Documentation/
}
\usage{
catalogueMOPEX(MAP = TRUE)
}
\arguments{
\item{MAP}{Boolean, TRUE by default. If FALSE it returns a list of the USGS
station ID’s and the gage locations of all 1861 potential MOPEX basins.
If TRUE, it return a list of the USGS station ID’s and the gage locations of
the 438 MOPEX basins with MAP estimates.}
}
\value{
This function returns a data frame containing the following columns:
\describe{
  \item{\code{USGS_ID}}{Station id number}
  \item{\code{Longitude}}{Decimal degrees East}
  \item{\code{Latitude}}{Decimal degrees North}
  \item{\code{Drainage_Area}}{Square Miles}
  \item{\code{R_gauges}}{Required number of precipitation gages to meet MAP accuracy criteria}
  \item{\code{N_gauges}}{Number of gages in total gage window used to estimate MAP}
  \item{\code{A_gauges}}{Avaliable number of gages in the basin}
  \item{\code{Ratio_AR}}{Ratio of Available to Required number of gages in the basin}
  \item{\code{Date_start}}{Date when recordings start}
  \item{\code{Date_end}}{Date when recordings end}
  \item{\code{State}}{State of the basin}
  \item{\code{Name}}{Name of the basin}
}
Columns Date_start, Date_end, State, Name are taken from:
https://hydrology.nws.noaa.gov/pub/gcip/mopex/US_Data/Basin_Characteristics/usgs431.txt
Date_start and Date_end are conventionally set to the first of the month
here, however actual recordings my differ. Always refer to the recording date
obtained as output of \code{tsMOPEX()}.
}
\description{
This function retrieves the list of the MOPEX basins.
}
\examples{
\dontrun{
  # Retrieve the MOPEX catalogue
  catalogue <- catalogueMOPEX()
}

}
\author{
Claudia Vitolo
}
