% Generated by roxygen2 (4.0.2): do not edit by hand
\name{GRDCMonthlyTS}
\alias{GRDCMonthlyTS}
\title{Interface for the Global Runoff Data Centre database of Monthly Time Series}
\usage{
GRDCMonthlyTS(stationID, plotOption = FALSE)
}
\arguments{
\item{stationID}{7 character number that identifies a station, GRDC station number is called "grdc no" in the catalogue.}

\item{plotOption}{boolean to define whether to plot the results. By default this is set to TRUE.}
}
\value{
The function returns a list of 3 tables: \describe{
  \item{\strong{mddPerYear}}{This is a table containing mean daily discharges for each single year (n records, one per year). It is made of 7 columns which description is as follows:}\itemize{
  \item LQ:    lowest monthly discharge of the given year
  \item month: associated month of occurrence
  \item MQ:    mean discharge of all monthly discharges in the given year
  \item HQ:    highest monthly discharge of the given year
  \item month: associated month of occurrence
  \item n:    number of available values used for MQ calculationFirst item
}
  \item{\strong{mddAllPeriod}}{This is a table containing mean daily discharges for the entire period (Calculated only from years with less than 2 months missing). It is made of 6 columns which description is as follows:}\itemize{
  \item LQ:   lowest monthly discharge from the entire period
  \item MQ_1: mean discharge of all monthly discharges in the period [m3/s]
  \item MQ_2: mean discharge volume per year of all monthly discharges in the period [km3/a]
  \item MQ_3: mean runoff per year of all monthly discharges in the period [mm/a]
  \item HQ:   highest monthly discharge from the entire periode
  \item n:    number of available months used for MQ calculation
}
\item{\strong{mddPerMonth}}{This is a table containing mean daily discharges for each month over the entire period (12 records covering max. n years. Calculated only for months with less then or equal to 10 missing days). It is made of 7 columns which description is as follows:}\itemize{
  \item LQ:    lowest monthly discharge of the given month in the entire period
  \item year:  associated year of occurrence (only the first occurence is listed)
  \item MQ:    mean discharge from all monthly discharges of the given month in the entire period
  \item HQ:    highest monthly discharge of the given month in the entire period
  \item year:  associated year of occurrence (only the first occurence is listed)
  \item std:   standard deviation of all monthly discharges of the given month in the entire period
  \item n:     number of available daily values used for computation
}
}
}
\description{
This function interfaces the Global Runoff Data Centre monthly mean daily discharges database.
}
\details{
Please note that not all the GRDC stations listed in the catalogue have monthly data available.
}
\examples{
# x <- GRDCMonthlyTS(stationID=1107700)
}
\author{
Claudia Vitolo
}

