% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{Exponential}
\alias{Exponential}
\alias{SymmetricExponential}
\alias{Gaussian}
\alias{PowerLaw}
\alias{Pareto3}
\alias{Pareto2}
\alias{Pareto1}
\title{Reproduction kernels for the Hawkes processes}
\description{
These classes are derived from the class \code{Model}, each implementing
a different reproduction kernel for the Hawkes process.
They inherit all fields from \link{Model}.
}
\details{
\itemize{
\item The kernel \code{Exponential} has density function
\deqn{h^\ast(t) = \beta \exp(-\beta t) 1_{\{t \ge 0\}}.}
Its vector of parameters must be of the form \eqn{(\eta, \mu, \beta)}.
Both \code{loglik}, its derivatives, and \code{whittle} can be used with this reproduction kernel.

\item The kernel \code{SymmetricExponential} has density function
\deqn{h^\ast(t) = 0.5 \beta \exp(-\beta |t|).}
Its vector of parameters must be of the form \eqn{(\eta, \mu, \beta)}.
Only \code{whittle} can be used with this reproduction kernel.

\item The kernel \code{Gaussian} has density function
\deqn{h^\ast(t) = \frac{1}{\sigma \sqrt{2\pi}}\exp\left(-\frac{(t-\nu)^2}{2\sigma^2}\right).}
Its vector of parameters must be of the form \eqn{(\eta, \mu, \nu, \sigma^2)}.
Only \code{whittle} is available with this reproduction kernel.

\item The kernel \code{PowerLaw} has density function
\deqn{h^\ast(t) = \theta a^\theta (t+a)^{-\theta-1} 1_{\{\theta > 0 \}}.}
Its vector of parameters must be of the form \eqn{(\eta, \mu, \theta, a)}.
Both \code{loglik}, its derivatives, and \code{whittle} can be used with this reproduction kernel.

\item The kernels \code{Pareto3}, \code{Pareto2} and \code{Pareto1} have density function
\deqn{h_\theta^\ast(t) = \theta a^\theta t^{-\theta - 1} 1_{\{t > a\}},}
with \eqn{\theta} = 3, 2 and 1 respectively.
Their vectors of parameters must be of the form \eqn{(\eta, \mu, a)}.
Only \code{whittle} is available with this reproduction kernel.
}
}
\seealso{
\link{Model}
}
