% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-weights.R
\name{importance_weights}
\alias{importance_weights}
\title{Importance weights}
\usage{
importance_weights(x)
}
\arguments{
\item{x}{A double vector.}
}
\value{
A new importance weights vector.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{importance_weights()} creates a vector of importance weights which allow you
to apply a context dependent weight to your observations. Importance weights
are supplied as a non-negative double vector, where fractional values are
allowed.
}
\details{
Importance weights focus on how much each row of the data set should
influence model estimation. These can be based on data or arbitrarily set to
achieve some goal.

In tidymodels, importance weights only affect the model estimation and
\emph{supervised} recipes steps. They are not used with yardstick functions for
calculating measures of model performance.
}
\examples{
importance_weights(c(1.5, 2.3, 10))
}
\seealso{
\code{\link[=frequency_weights]{frequency_weights()}}
}
