% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wms_raster.R
\name{get_wms_raster}
\alias{get_wms_raster}
\title{Download WMS raster layer}
\usage{
get_wms_raster(shape,
               apikey,
               layer_name,
               resolution = NULL)
}
\arguments{
\item{shape}{Object of class \code{sf}. Needs to be located in
France.}

\item{apikey}{API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{layer_name}{Name of the layer from \code{get_layers_metadata(apikey, "wms")}
or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{resolution}{Cell size in meter. WMS are limited to 2048x2048 pixels.
See detail for more information about resolution.}
}
\value{
\code{get_wms_raster} return an object of class \code{stars}. Depending on the layer,
this can be a simple raster (2 dimensions and 1 attribute) or an RGB
raster (3 dimensions and 1 attribute).
}
\description{
Directly download a raster layer from the French National Institute
of Geographic and Forestry. To do that, it need a location giving by
a shapefile, an apikey and the name of layer. You can find those
information from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}
}
\details{
\itemize{
\item If the resolution is too high, the maximum is automatically set by
dividing height and width of the shape's bbox by 2048
(the maximum number of pixel)
\item Setting the \code{resolution} parameter higher than the base resolution
of the layer multiplies the number of pixels without increasing
the precision. For example, the download of the BD Alti layer from
IGN will be optimal for a resolution of 25m. Look at
\href{https://geoservices.ign.fr/documentation/donnees/alti/bdalti}{IGN documentation}
for more precision on layer's resolution.
}
}
\examples{
\dontrun{
library(sf)
library(stars)
library(tmap)

apikey <- get_apikeys()[4]

metadata_table <- get_layers_metadata(apikey, "wms")
layer_name <- metadata_table[2,2]

# shape from the best town in France
shape <- st_polygon(list(matrix(c(-4.373937, 47.79859,
                                 -4.375615, 47.79738,
                                 -4.375147, 47.79683,
                                 -4.373898, 47.79790,
                                 -4.373937, 47.79859),
                                 ncol = 2, byrow = TRUE)))
shape <- st_sfc(shape, crs = st_crs(4326))

# Downloading digital elevation model from IGN
mnt <- get_wms_raster(shape, apikey, layer_name, resolution = 1)
mnt[mnt < 0] <- NA # remove negative values in case of singularity
names(mnt) <- "Elevation [m]" # Rename raster ie the title legend

# Verif
qtm(mnt)+
qtm(shape, fill = NULL, borders.lwd = 3)
}
}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}, \code{\link[=get_layers_metadata]{get_layers_metadata()}}
}
