% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{plot_cluster_trajectories,hbr-method}
\alias{plot_cluster_trajectories}
\alias{plot_cluster_trajectories,hbr-method}
\alias{plot_cluster_trajectories.hbr}
\title{Method to visualize the trajectories for all identified clusters in a window}
\usage{
\S4method{plot_cluster_trajectories}{hbr}(object, window, ylim = c(0, 1),
  p.median = T, tp.cor = T)
}
\arguments{
\item{object}{object of class \code{hbr}}

\item{window}{numeric specifying the number of the window, for which trajectories 
should be plotted.}

\item{ylim}{numeric vector with two elements specifying the limits of the y-axis.}

\item{p.median}{boolean specifying if the median trajectory for each cluster should 
be added to the plot (default: TRUE).}

\item{tp.cor}{Boolean indicating if only the time points used for calaculating
correlations \code{use.libs} are shown (tp.cor=T) or all time points present in the
data set are shown (tp.cor=F).}
}
\description{
Method to visualize the trajectories for all identified clusters in a window
}
\details{
The method operates on \code{\link{hbr}} objects and plots the trajectories
of all clusters and replicates in the specified window. Cluster trajectories are
visualized by trajectories of all markers contained in the respective clusters and
median trajectories for a cluster are visualized in a different color. For each
cluster it is indicated to which haplotype-block it was later assigned.
NOTE: It is possible that to clusters are assigned to the identical
haplotype-block. This can happen when a cluster in an overlapping window shares 
markers with two clusters of the "focal" window.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

