% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv_programmes.R
\name{tv_programmes}
\alias{tv_programmes}
\alias{hansard_tv_programmes}
\alias{tv_clips}
\alias{hansard_tv_clips}
\alias{tv_channels}
\alias{hansard_tv_channels}
\title{TV broadcast data}
\usage{
tv_programmes(legislature = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_tv_programmes(legislature = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

tv_clips(mp_id = NULL, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")

hansard_tv_clips(mp_id = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

tv_channels(tidy = TRUE, tidy_style = "snake_case")

hansard_tv_channels(tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{legislature}{Accepts one of either 'commons' or 'lords'. If NULL, returns all TV programmes for all chambers.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}

\item{mp_id}{Accepts the ID of an MP or peer, and returns all clips featuring that MP or peer. If NULL, returns data on all available clips. Defaults to NULL.}
}
\value{
A tibble with details on TV broadcasts.

A tibble with details on TV broadcasts featuring the given MP, or all available clips.

A tibble with details on the different broadcasting channels.
}
\description{
Imports data on TV broadcasts.

Clips of individual members

Returns data on the different parliamentary broadcasting channels.
}
\examples{
\dontrun{

x <- tv_programmes('commons', start_date ='2016-11-01')

}
\dontrun{
x <- tv_clips(4591)
}
}
\keyword{TV}
