% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_writer_profiles}
\alias{compare_writer_profiles}
\title{Compare Writer Profiles}
\usage{
compare_writer_profiles(
  writer_profiles,
  score_only = TRUE,
  rforest = NULL,
  reference_scores = NULL
)
}
\arguments{
\item{writer_profiles}{A dataframe of writer profiles or cluster fill rates
calculated with \link{get_cluster_fill_rates}}

\item{score_only}{TRUE returns only the similarity score. FALSE returns the
similarity score and a score-based likelihood ratio for that score,
calculated using \code{reference_scores}.}

\item{rforest}{Optional. A random forest created with \code{\link[ranger:ranger]{ranger::ranger()}}.
If a random forest is not supplied, \code{random_forest} will be used.}

\item{reference_scores}{Optional. A list of same writer and different writer
similarity scores used for reference to calculate a score-based likelihood
ratio. If reference scores are not supplied, \code{ref_scores} will be used only
if \code{score_only} is FALSE. If score only is true, reference scores are
unnecessary because a score-based likelihood ratio will not be calculated.
If reference scores are supplied, \code{score_only} will automatically be set to
FALSE.}
}
\value{
A dataframe
}
\description{
Compare the writer profiles from two handwritten documents to predict whether
they were written by the same person. Use either a similarity score or a
score-based likelihood ratio as a comparison method.
}
\examples{
compare_writer_profiles(test[1:2, ], score_only = TRUE)

compare_writer_profiles(test[1:2, ], score_only = FALSE)

}
