% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModeling_analysisfunctions.R
\name{analyze_questioned_documents}
\alias{analyze_questioned_documents}
\title{Analyze Questioned Documents}
\usage{
analyze_questioned_documents(
  template_dir,
  questioned_images_dir,
  model,
  num_cores,
  num_graphs = "All",
  writer_indices,
  doc_indices
)
}
\arguments{
\item{template_dir}{A directory that contains a cluster template created by \code{\link[=make_clustering_templates]{make_clustering_templates()}}}

\item{questioned_images_dir}{A directory containing questioned documents}

\item{model}{A fitted model created by \code{\link[=fit_model]{fit_model()}}}

\item{num_cores}{An integer number of cores to use for parallel processing
with the \code{doParallel} package.}

\item{num_graphs}{"All" or integer number of graphs to randomly select from each questioned document.}

\item{writer_indices}{A vector of start and stop characters for writer IDs in file names}

\item{doc_indices}{A vector of start and stop characters for document names in file names}
}
\value{
A list of likelihoods, votes, and posterior probabilities of
writership for each questioned document.
}
\description{
\code{analyze_questioned_documents()} estimates the posterior probability of
writership for the questioned documents using Markov Chain Monte Carlo (MCMC) draws from a hierarchical
model created with \code{\link[=fit_model]{fit_model()}}.
}
\examples{
\dontrun{
template_dir <- "/path/to/template_dir"
questioned_images_dir <- "/path/to/questioned_images"
analysis <- analyze_questioned_documents(
  template_dir = template_dir,
  questioned_images_dir = questioned_images_dir,
  model = model,
  num_cores = 2,
  num_graphs = "All",
  writer_indices = c(2, 5),
  doc_indices = c(7, 18)
)
analysis$posterior_probabilities
}

}
