% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_basis.R
\name{basis_list_cols}
\alias{basis_list_cols}
\title{List Basis Functions}
\usage{
basis_list_cols(
  cols,
  x,
  smoothness_orders,
  include_zero_order,
  include_lower_order = FALSE
)
}
\arguments{
\item{cols}{Index or indices (as \code{numeric}) of covariates (columns) of
interest in the data matrix \code{x} for which basis functions ought to be
generated. Note that basis functions for interactions of these columns are
computed automatically.}

\item{x}{A \code{matrix} containing observations in the rows and covariates
in the columns. Basis functions are computed for these covariates.}

\item{smoothness_orders}{An integer vector of length \code{ncol(x)}
specifying the desired smoothness of the function in each covariate. k = 0
is no smoothness (indicator basis), k = 1 is first order smoothness, and so
on. For an additive model, the component function for each covariate will
have the degree of smoothness as specified by smoothness_orders. For
non-additive components (tensor products of univariate basis functions),
the univariate basis functions in each tensor product have smoothness
degree as specified by smoothness_orders.}

\item{include_zero_order}{A \code{logical}, indicating whether the zeroth
order basis functions are included for each covariate (if \code{TRUE}), in
addition to the smooth basis functions given by \code{smoothness_orders}.
This allows the algorithm to data-adaptively choose the appropriate degree
of smoothness.}

\item{include_lower_order}{A \code{logical}, like \code{include_zero_order},
except including all basis functions of lower smoothness degrees than
specified via \code{smoothness_orders}.}
}
\value{
A \code{list} containing the basis functions generated from a set of
input columns.
}
\description{
Build a list of basis functions from a set of columns
}
